#include "h/p33FJ64GP802.h"
#include "h/clock.h"

TIMET currentTime;

void initTime(void)
{
	currentTime.ticks=0;
	currentTime.seconds=0;
	currentTime.minutes=0;
	T3CONbits.TCKPS=0b11;		// 1:256 division ratio
	T3CONbits.TCS=0;			// FCY= 40 MIPS clock
	T3CONbits.TGATE=0;
	PR3=15625;					// 40Mhz / 256 / 15625 = 100ms period
	IFS0bits.T3IF=0;
	IEC0bits.T3IE=1;			// enable interrupt
	T3CONbits.TON=1;
}

TIMET getTime(void)
{
	return currentTime;
}

void __attribute__((interrupt, no_auto_psv))_T3Interrupt(void)
{
	if(currentTime.ticks<9)currentTime.ticks++; 
	else 
	{
		currentTime.ticks=0;
		if(currentTime.seconds<59)currentTime.seconds++;
		else
		{
			currentTime.seconds=0;
			if(currentTime.minutes<59)currentTime.minutes++;
			else
			{
				currentTime.minutes=0;
			}
		}
	}
	IFS0bits.T3IF=0;
}
